IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_GERA_PIS_COFINS_EST_NF_SAI]') AND TYPE IN (N'P', N'PC'))
	DROP PROCEDURE [DBO].[P_GERA_PIS_COFINS_EST_NF_SAI]
GO
-- VERSAO 2782
/*

EXEC P_GERA_PIS_COFINS_EST_NF_SAI 1,2,'20230207','20230207',0,'',0

*/
/*
=======================================================================================
'Job.................:  
'Funo..............: 
'Objetivo............:
'Tabelas.............: 
'Dt Modificao......: 25/05/2021
'Modificao.........: Tag #A001 Atualizar PIS_COFINS de acordo com TP_TRIB da tabela CST_PIS_COFINS
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 
*/

CREATE PROCEDURE [DBO].[P_GERA_PIS_COFINS_EST_NF_SAI] (@CD_EMP INT, 
													   @CD_FILIAL INT, 
													   @DT_INI DATETIME,
													   @DT_FIM DATETIME,
													   @VISUALIZAR INT = 0,
													   @CODIGO VARCHAR(200)= '',
													   @FLAG_REPROCESSAR INT=0)  WITH ENCRYPTION AS 
													   



SET NOCOUNT ON 

--DECLARE @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS INT = NULL 
--DECLARE @DATADEDUZIR DATE = NULL

--	SET @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS= ISNULL ( (SELECT DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS FROM PRC_FILIAL WHERE CD_FILIAL = @CD_FILIAL ), 0)
--	SET @DATADEDUZIR = ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'DT_INICIO_EXCLUSAO_ICMS_PIS_COFINS', 1, @CD_FILIAL)),0)


/*
=======================================================================================
'Job.................: Itec - Gerao PIS e Cofins
'Funo..............: 
'Objetivo............: Gera pis cofins dos itens na Saida
'Tabelas.............: EST_NF_SAI_IT
'Dt Modificao......: 20/11/2020
'Modificao.........: Tag #A001 - Remoo do codigo , pois, a execuo da rotina j existe em job.Estava ocorrendo conflitos.  
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 

*/

--VERIFICA BLOQUEIO CONTBIL
IF EXISTS( SELECT TOP 1 CD_EMP
    FROM
         CTB_CONTROLE_EXPORTACAO
    WHERE LIBERADO = 'N'
          AND DT_EXPORT >= @DT_INI
          AND CD_EMP = @CD_EMP
          AND CD_FILIAL = @CD_FILIAL
)
    BEGIN
        PRINT 'DATA BASE COM BLOQUEIO CONTABIL - TIME : '+CONVERT(VARCHAR, GETDATE(), 108);
        RAISERROR('DATA BASE COM BLOQUEIO CONTABIL', 9, 1);
        RETURN;
    END;

--VERIFICA BLOQUEIO FISCAL

IF EXISTS( SELECT TOP 1
           CD_EMP
    FROM
         CTB_EXP_CTR
    WHERE LIBERADO = 'N'
          AND CD_EMP = @CD_EMP
          AND DT_EXP >= @DT_INI
          AND CD_FILIAL = @CD_FILIAL
          AND TP_EXP = 0
)
    BEGIN
        PRINT 'DATA BASE COM BLOQUEIO CONTABIL - TIME : '+CONVERT(VARCHAR, GETDATE(), 108);
        RAISERROR('DATA BASE COM BLOQUEIO FISCAL', 9, 1);
        RETURN;
    END;

CREATE TABLE #RSSAIDAS (	CD_EMP INT,
							CD_FILIAL INT,
							CD_NF INT,
							CD_IT INT,
							CD_PROD INT,
							QT_IT MONEY,
							VLR_IT MONEY,
							VLR_DESC MONEY,
							VLR_BASE_ICMS MONEY,
							ISENTO INT,
							SUBS_TRIB_ANT INT,
							ICMS INT,
							SUBS_TRIB INT,
							ICMS_RD INT,
							PIS_COFINS_RECALCULADO INT,
							CST_PIS INT,
							PERC_ALIQ_PIS  MONEY,
							VLR_BASE_PIS  MONEY,
							VLR_PIS  MONEY,
							CST_COFINS INT,
							PERC_ALIQ_COFINS  MONEY,
							VLR_BASE_COFINS  MONEY,
							VLR_COFINS MONEY,
							REGIME_TRIBUTARIO INT,
							PIS_COFINS INT, 
							VLR_DEDUCAO_PROT_ICMS_ST MONEY
							)

-- Tag #A001
--GERANDO TABELA INICIAL COM O CALCULO PADRAO DE PIS/COFINS
INSERT INTO #RSSAIDAS
SELECT
	EST_NF_SAI.CD_EMP,
	EST_NF_SAI.CD_FILIAL,
	EST_NF_SAI.CD_NF,
	EST_NF_SAI_IT.CD_IT,
	EST_NF_SAI_IT.CD_PROD,
	EST_NF_SAI_IT.QT_IT,
	EST_NF_SAI_IT.VLR_IT,
	EST_NF_SAI_IT.VLR_DESC_IT,
	EST_NF_SAI_IT.VLR_BASE_ICMS_IT,
	EST_TRIB.ISENTO,
	EST_TRIB.SUBS_TRIB_ANT,
	EST_TRIB.ICMS,
	EST_TRIB.SUBS_TRIB,
	EST_TRIB.ICMS_RD,
	1 AS PIS_COFINS_RECALCULADO,
	B.CD_CST_PIS,
	B.PERC_PIS,
	B.VLR_BASE_PIS,
	B.VLR_PIS,
	B.CD_CST_COFINS,
	B.PERC_COFINS,
	B.VLR_BASE_COFINS,   --ALTER TABLE EST_NF_SAI ADD REGIME_TRIBUTARIO INT NULL
	B.VLR_COFINS,
	ISNULL(EST_NF_SAI.REGIME_TRIBUTARIO,0),
	--B.PROD_PIS_COFINS
	B.CST_TP_TRIB_PIS,
	ISNULL((mov.VLR_ICMS_ST_DARE +
								 mov.VLR_ICMS_EFETIVO +
								 mov.VLR_ICMS_SUBS +
								 mov.VLR_ICMS_RET +
								 mov.VLR_FECOP +
								 mov.VLR_FECOP_RET +
								 mov.VLR_FECOP_ST),0) AS VLR_DEDUCAO_PROT_ICMS_ST
FROM
	EST_NF_SAI INNER JOIN EST_NF_SAI_IT ON
	EST_NF_SAI.CD_EMP = EST_NF_SAI_IT.CD_EMP AND
	EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL AND
	EST_NF_SAI.CD_NF = EST_NF_SAI_IT.CD_NF
	INNER JOIN EST_TRIB ON
	EST_NF_SAI_IT.CD_TRIB = EST_TRIB.CD_TRIB
	--OUTER APPLY UFD_EST_PROD_TRIB_PIS_COFINS(EST_NF_SAI.CD_EMP,EST_NF_SAI.CD_FILIAL,EST_NF_SAI.CD_NT_MOV,CD_PROD,EST_NF_SAI_IT.CD_NT_OP,
	--(EST_NF_SAI_IT.VLR_TOT_IT-EST_NF_SAI_IT.VLR_DESC_IT), ISNULL(EST_NF_SAI.REGIME_TRIBUTARIO,0)) B
	LEFT JOIN GLB_NT_OP OP ON OP.CD_NT_OP = EST_NF_SAI_IT.CD_NT_OP		
		OUTER APPLY DBO.UFD_EST_PROD_TRIB_PIS_COFINS(EST_NF_SAI.CD_EMP,EST_NF_SAI.CD_FILIAL,
				    EST_NF_SAI.CD_NT_MOV,
				    CD_PROD,
				    EST_NF_SAI_IT.CD_NT_OP,
				    ((EST_NF_SAI_IT.VLR_TOT_IT)-(EST_NF_SAI_IT.VLR_DESC_IT   )),0, EST_NF_SAI.CD_NF, 0, 0) B
	LEFT JOIN EST_NF_ENT_ENTRADA_ICMS_ST_MOV mov on EST_NF_SAI_IT.prot_icms_st = MOV.prot_icms_st
													AND MOV.STATUS = 1
WHERE
	EST_NF_SAI.CD_EMP = @CD_EMP 
	AND EST_NF_SAI.CD_FILIAL = @CD_FILIAL 
	AND EST_NF_SAI.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM
	--AND ISNULL(EST_NF_SAI_IT.PROT_ICMS_ST,0) = 0

--Tag #A001
--ALTERANDO A ENTRADA DE ACORDO COM O NOVO CALCULO CRIADO
IF @VISUALIZAR =0 
BEGIN
	UPDATE
		S
	SET 
		S.VLR_BASE_PIS = CASE WHEN snv.VLR_DEDUCAO_PROT_ICMS_ST < snv.VLR_BASE_PIS THEN snv.VLR_BASE_PIS - snv.VLR_DEDUCAO_PROT_ICMS_ST
											ELSE snv.VLR_BASE_PIS END, 
		S.VLR_PIS= CASE WHEN snv.VLR_DEDUCAO_PROT_ICMS_ST < snv.VLR_BASE_PIS THEN
											CASE WHEN snv.VLR_DEDUCAO_PROT_ICMS_ST > 0
													THEN ROUND((((snv.VLR_BASE_PIS - snv.VLR_DEDUCAO_PROT_ICMS_ST)) * snv.PERC_ALIQ_PIS) / 100.00, 2)
												ELSE snv.VLR_PIS END
					END,		
		S.PERC_ALIQ_PIS=SNV.PERC_ALIQ_PIS,	
		S.VLR_BASE_COFINS= CASE WHEN snv.VLR_DEDUCAO_PROT_ICMS_ST < snv.VLR_BASE_COFINS THEN snv.VLR_BASE_COFINS - snv.VLR_DEDUCAO_PROT_ICMS_ST
												ELSE snv.VLR_BASE_COFINS END,
		S.VLR_COFINS= CASE WHEN snv.VLR_DEDUCAO_PROT_ICMS_ST < snv.VLR_BASE_COFINS THEN 
												CASE WHEN snv.VLR_DEDUCAO_PROT_ICMS_ST > 0
														THEN ROUND((((snv.VLR_BASE_COFINS - snv.VLR_DEDUCAO_PROT_ICMS_ST)) * snv.PERC_ALIQ_COFINS) / 100.00, 2)
													ELSE snv.VLR_COFINS END
										ELSE snv.VLR_COFINS END,
		S.PERC_ALIQ_COFINS=SNV.PERC_ALIQ_COFINS, 
		S.CST_PIS=SNV.CST_PIS,		
		S.CST_COFINS=SNV.CST_COFINS,
		S.PIS_COFINS = SNV.PIS_COFINS,
		S.PIS_COFINS_RECALCULADO=SNV.PIS_COFINS_RECALCULADO,
		S.VLR_ISENTO = CASE WHEN SNV.ISENTO = 1 THEN
							CASE WHEN ((S.QT_IT * S.VLR_IT) - S.VLR_DESC_IT) > 0 THEN
								(S.QT_IT * S.VLR_IT) - S.VLR_DESC_IT
							ELSE
								0
							END
					   ELSE
							0
					   END,
		S.VLR_OUTROS =CASE WHEN SNV.SUBS_TRIB_ANT = 1 THEN 
							CASE WHEN ((S.QT_IT * S.VLR_IT) - S.VLR_DESC_IT) > 0 THEN
								((S.QT_IT * S.VLR_IT) - S.VLR_DESC_IT)
							ELSE
								0
							END
					  ELSE
						CASE WHEN (SNV.ICMS + SNV.SUBS_TRIB + SNV.ICMS_RD)  > 1 THEN 
										CASE WHEN ((S.QT_IT * S.VLR_IT) - S.VLR_DESC_IT) - S.VLR_BASE_ICMS_IT > 0 THEN
											((S.QT_IT * S.VLR_IT) - S.VLR_DESC_IT) - S.VLR_BASE_ICMS_IT 
										ELSE
											0
										END
						ELSE
							0
						END
					  END		
	FROM
		#RSSAIDAS SNV INNER JOIN EST_NF_SAI_IT S ON
		SNV.CD_EMP = S.CD_EMP AND
		SNV.CD_FILIAL = S.CD_FILIAL AND 
		SNV.CD_NF = S.CD_NF AND
		SNV.CD_PROD = S.CD_PROD AND
		SNV.CD_IT = S.CD_IT 
END

/*
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
-- Tag #A001
IF  @VISUALIZAR =0
BEGIN
	WHILE @DT_INI <=@DT_FIM
		BEGIN
			EXEC P_EST_MOVIMENTO_VENDAS 1, @DT_INI, @CD_FILIAL ,1
			SET @DT_INI = DATEADD(DAY,1,@DT_INI) 
		 
		END
END
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/


-------------------------------------INCLUIR PENDENCIA DE PROCESSAMENTO "EST_MOVIMENTO_VENDAS"---------------------------------------------------------

DECLARE @CD_CTR_PENDENCIA INT

WHILE @DT_INI <=@DT_FIM
BEGIN
	SET @CD_CTR_PENDENCIA = 0;
	
	SET @CD_CTR_PENDENCIA=ISNULL((SELECT
								 TOP 1 CD_CTR 
							FROM 
								GLB_DT_MOVIMENTO INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_PENDENTE ON
								GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO = EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO
							WHERE
								GLB_DT_MOVIMENTO.DT_MOVIMENTO=@DT_INI),0)	
	IF @CD_CTR_PENDENCIA=0 
	BEGIN
		 INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
		 (CD_CTR_DT_MOVIMENTO,
		  DT_CAD,
		  ANO_MES,
		  ANO,
		  MES
		  ,ROTINA
		 )
		SELECT 
			GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO,
			GETDATE(),
			GLB_DT_MOVIMENTO.ANO_MES_MOVIMENTO,
			GLB_DT_MOVIMENTO.ANO_MOVIMENTO,
			GLB_DT_MOVIMENTO.MES_MOVIMENTO,
			OBJECT_NAME(@@PROCID)
		FROM
			 GLB_DT_MOVIMENTO 
		WHERE
			GLB_DT_MOVIMENTO.DT_MOVIMENTO=@DT_INI

		SET @CD_CTR_PENDENCIA=IDENT_CURRENT('EST_PROD_CPL_VD_LOTE_PROC_PENDENTE');
	END

	INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL
				(CD_CTR,
				CD_EMP,
				CD_FILIAL
				)
				SELECT 
					DISTINCT @CD_CTR_PENDENCIA,
					PRC_FILIAL.CD_EMP,
					PRC_FILIAL.CD_FILIAL
				FROM 
					PRC_FILIAL LEFT OUTER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL ON
					PRC_FILIAL.CD_EMP = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_EMP AND
					PRC_FILIAL.CD_FILIAL = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_FILIAL AND
					@CD_CTR_PENDENCIA = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_CTR
				WHERE
					PRC_FILIAL.CD_FILIAL=@CD_FILIAL
					AND EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_CTR IS NULL;

	SET @DT_INI = DATEADD(DAY,1,@DT_INI);
END

----------------------------------------------------------------------------------------------------------------



IF @VISUALIZAR =1 
BEGIN
--ALTERANDO A ENTRADA DE ACORDO COM O NOVO CALCULO CRIADO
SELECT
*
FROM
	#RSSAIDAS 
END
DROP TABLE #RSSAIDAS;
